/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.client.animation.impl.CatLeapAnimator;
import com.alrex.parcool.client.input.KeyRecorder;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.action.impl.FastRun;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.impl.Animation;
import com.alrex.parcool.common.capability.impl.Parkourability;
import java.nio.ByteBuffer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CatLeap
extends Action {
    private int coolTimeTick = 0;
    private boolean ready = false;
    private int readyTick = 0;
    private int MAX_COOL_TIME_TICK = 30;

    @Override
    public void onTick(Player player, Parkourability parkourability, IStamina stamina) {
        if (this.coolTimeTick > 0) {
            --this.coolTimeTick;
        }
    }

    @Override
    public void onClientTick(Player player, Parkourability parkourability, IStamina stamina) {
        if (player.m_7578_()) {
            if (KeyRecorder.keySneak.isPressed() && parkourability.get(FastRun.class).getNotDashTick(parkourability.getAdditionalProperties()) < 10) {
                this.ready = true;
            }
            if (this.ready) {
                ++this.readyTick;
            }
            if (this.readyTick > 10) {
                this.ready = false;
                this.readyTick = 0;
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canStart(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startInfo) {
        return parkourability.getActionInfo().can(CatLeap.class) && player.m_20096_() && !stamina.isExhausted() && this.coolTimeTick <= 0 && this.readyTick > 0 && KeyRecorder.keySneak.isReleased();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canContinue(Player player, Parkourability parkourability, IStamina stamina) {
        return (this.getDoingTick() <= 1 || !player.m_20096_()) && !player.m_21255_() && !player.m_20072_() && !player.m_20077_();
    }

    @Override
    public void onStartInLocalClient(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startData) {
        double catLeapYSpeed = 0.49;
        Vec3 motionVec = player.m_20184_();
        Vec3 vec = new Vec3(motionVec.f_82479_, 0.0, motionVec.f_82481_).m_82541_();
        this.coolTimeTick = this.MAX_COOL_TIME_TICK;
        player.m_20334_(vec.f_82479_, 0.49, vec.f_82481_);
        Animation animation = Animation.get(player);
        if (animation != null) {
            animation.setAnimator(new CatLeapAnimator());
        }
    }

    @Override
    public void onStartInOtherClient(Player player, Parkourability parkourability, ByteBuffer startData) {
        Animation animation = Animation.get(player);
        if (animation != null) {
            animation.setAnimator(new CatLeapAnimator());
        }
    }

    @Override
    public StaminaConsumeTiming getStaminaConsumeTiming() {
        return StaminaConsumeTiming.OnStart;
    }

    public float getCoolDownPhase() {
        return ((float)this.MAX_COOL_TIME_TICK - (float)this.coolTimeTick) / (float)this.MAX_COOL_TIME_TICK;
    }
}

